//g++ -o p main.cpp -lGL -lglut -lGLU

#define GLM_ENABLE_EXPERIMENTAL
#include <GL/freeglut.h>
#include <glm/vec3.hpp>
#include <glm/mat4x4.hpp>
#include <glm/gtx/transform.hpp>
#include <glm/gtx/rotate_vector.hpp>
#include <vector>
#include <stdio.h>
#include <math.h>

using namespace glm;
using namespace std;

#define MOVING_CONST 0.1
#define ROTATION_CONST 3.14f / 180.f
#define LOOK_MOVEMENT_CONST 0.1f

/*--------------------------------------------------*/

char title[] = "Prozor";
int FPS = 60;
vec3 CameraPosition(1.0, 1.0, 1.0);
vec3 LookAt_vector(0.0, 0.0, 0.0);
vec3 LookUp_vector(0.0, 1.0, 0.0);
vector<vec3> coordinateSystem;

const int circle_dots = 50;
const float height = 480;
const float ratio = 16.f / 9.f;
double upDownAngle = 0;
int currentSpeed = 1;
float arrowRotate = 0.f;

vec3 operator* (mat4x4 mat, vec3 vec)
{
	vec4 v(vec.x, vec.y, vec.z, 1.f);
	v = mat * v;
	return vec3(v.x, v.y, v.z);
}

vector<vec3> operator* (mat4x4 mat, vector<vec3> vectors)
{
	for (int i = 0; i < vectors.size(); i++)
		vectors[i] = mat * vectors[i];
	return vectors;
}

void DrawPolygon(vector<vec3> &polygon)
{
	glBegin(GL_POLYGON);
	for(unsigned int i=1; i<polygon.size(); i++){
	glVertex3d(polygon[i].x, polygon[i].y,polygon[i].z);
	}
	glEnd();
}



void DrawCircle(double x, double y, double r, int circle_points)
{
float alpha = 2*M_PI/circle_points;
for(int i=0; i<circle_points; i++){
glVertex3d(r+x*cos(alpha*i), r+y*sin(alpha*i), r);
glColor3f(0.0f, 0.0f, 1.0f); // Blue
}
}


void CreateRectangle(vector <vec3> &rectangle){
	rectangle.resize(2);
	rectangle[0][0]= glVertex2d(0.0, 0.0);
	rectangle[0][1]= glVertex2d(0.0, 1.0);
	rectangle[1][0]= glVertex2d(0.0, 1.0);
	rectangle[1][1]= glVertex2d(2.0, 0.0);
}
void DrawRectangle(vector <vec3> &rectangle){
vector<vec3> poly;
poly[0][0]=rectangle[0][0];
poly[0][1]=rectangle[0][1];
poly[1][0]=rectangle[1][0];
poly[1][1]=rectangle[1][1];
DrawPolygon(poly);

}



//o GLUT_BITMAP_TIMES_ROMAN_24
//o GLUT_BITMAP_TIMES_ROMAN_10
//o GLUT_BITMAP_HELVETICA_18

void RenderString(float x, float y, void* font, double r, double g, double b)
{
	glColor3f(r, g, b);
	glRasterPos2f(x, y);

	char s[100];
	sprintf(s, "x = %.2lf\ny = %.2lf\nz = %.2lf", CameraPosition.x, CameraPosition.y, CameraPosition.z);
	glutBitmapString(font, (const unsigned char*)s);
}

/*--------------------------------------------------*/
void createCoordinates()
{
	coordinateSystem.resize(4);
	coordinateSystem[0] = vec3(0.0, 0.0, 0.0);
	coordinateSystem[1] = vec3(1.0, 0.0, 0.0);
	coordinateSystem[2] = vec3(0.0, 1.0, 0.0);
	coordinateSystem[3] = vec3(0.0, 0.0, 1.0);
}

void drawCoordinates()
{
	glLineWidth(2.0);
	glBegin(GL_LINES);
	// X axis
	glColor3f(1.0f, 0.0f, 0.0f); // Red
	glVertex3d(coordinateSystem[0].x, coordinateSystem[0].y, coordinateSystem[0].z);
	glVertex3d(coordinateSystem[1].x, coordinateSystem[1].y, coordinateSystem[1].z);
	// Y axis
	glColor3f(0.0f, 1.0f, 0.0f); // Green
	glVertex3d(coordinateSystem[0].x, coordinateSystem[0].y, coordinateSystem[0].z);
	glVertex3d(coordinateSystem[2].x, coordinateSystem[2].y, coordinateSystem[2].z);
	// Z axis
	glColor3f(0.0f, 0.0f, 1.0f); // Blue
	glVertex3d(coordinateSystem[0].x, coordinateSystem[0].y, coordinateSystem[0].z);
	glVertex3d(coordinateSystem[3].x, coordinateSystem[3].y, coordinateSystem[3].z);
	glEnd();
}



void display(void)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(80.f, 16.f / 9.f, 0.1f, 50.f);
	gluLookAt(
		CameraPosition.x, CameraPosition.y, CameraPosition.z,
		LookAt_vector.x, LookAt_vector.y, LookAt_vector.z,
		LookUp_vector.x, LookUp_vector.y, LookUp_vector.z
	);
	drawCoordinates();


	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	glDisable(GL_DEPTH_TEST);



	glEnable(GL_DEPTH_TEST);

	glutSwapBuffers();
}

void timer(int v)
{
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(
		CameraPosition.x, CameraPosition.y, CameraPosition.z,
		LookAt_vector.x, LookAt_vector.y, LookAt_vector.z,
		LookUp_vector.x, LookUp_vector.y, LookUp_vector.z
	);


	glutTimerFunc(1000 / FPS, timer, v);
	glutPostRedisplay();
}

void reshape(GLsizei width, GLsizei height)
{
	if (height * ratio <= width)
		width = ratio * height;
	else
		height = width / ratio;
	glViewport(0, 0, width, height);
}

void PrintVector(vec3 vec)
{
	printf("%.2f %.2f %.2f\n", vec.x, vec.y, vec.z);
}

void MoveForward()
{
	mat4x4 mt;
	vec3 v = LookAt_vector - CameraPosition;
	v = normalize(v);
	v.y = 0.f;
	v = v * (currentSpeed * (float)MOVING_CONST);

	mt = translate(mat4x4(1.f), v);

	LookAt_vector = mt * LookAt_vector;
	CameraPosition = mt * CameraPosition;
}

void MoveBackward()
{
	mat4x4 mt;
	vec3 v = LookAt_vector - CameraPosition;
	v.y = 0.f;
	v = normalize(v);

	v = -v * (currentSpeed * (float)MOVING_CONST);

	mt = translate(mat4x4(1.f), v);
	LookAt_vector = mt * LookAt_vector;
	CameraPosition = mt * CameraPosition;
}

void MoveLeft()
{
	mat4x4 mt;
	vec3 f = LookAt_vector - CameraPosition;
	vec3 w = cross(LookUp_vector, f);

	w = normalize(w);
	w = w * (currentSpeed * (float)MOVING_CONST);

	mt = translate(mat4x4(1.f), w);

	CameraPosition = mt * CameraPosition;
	LookAt_vector = mt * LookAt_vector;
}

void MoveRight()
{
	mat4x4 mt;
	vec3 f = LookAt_vector - CameraPosition;
	vec3 w = cross(LookUp_vector, f);

	w = normalize(w);
	w = -w * (currentSpeed * (float)MOVING_CONST);

	mt = translate(mat4x4(1.f), w);

	CameraPosition = mt * CameraPosition;
	LookAt_vector = mt * LookAt_vector;
}

void TurnLeft()
{
	mat4x4 mt, identityMat, mt1, mt2, mtr;

	identityMat = mat4x4(1.f);
	mt1 = translate(identityMat, vec3(CameraPosition.x, CameraPosition.y, CameraPosition.z));
	mtr = rotate(identityMat, ROTATION_CONST, vec3(0.f, 1.f, 0.f));
	mt2 = translate(identityMat, vec3(-CameraPosition.x, -CameraPosition.y, -CameraPosition.z));

	mt = mt1 * mtr * mt2;
	LookAt_vector = mt * LookAt_vector;

	arrowRotate += ROTATION_CONST;
}

void TurnRight()
{
	mat4x4 mt, identityMat, mt1, mt2, mtr;

	identityMat = mat4x4(1.f);
	mt1 = translate(identityMat, vec3(CameraPosition.x, CameraPosition.y, CameraPosition.z));
	mtr = rotate(identityMat, -ROTATION_CONST, vec3(0.f, 1.f, 0.f));
	mt2 = translate(identityMat, vec3(-CameraPosition.x, -CameraPosition.y, -CameraPosition.z));

	mt = mt1 * mtr * mt2;
	LookAt_vector = mt * LookAt_vector;

	arrowRotate -= ROTATION_CONST;
}

void TurnUp()
{
	mat4x4 mt, mt1, mt2, mtr;
	vec3 f = LookAt_vector - CameraPosition;
	vec3 w = cross(f, LookUp_vector);

	w = normalize(w);

	if (upDownAngle + ROTATION_CONST < (float)M_PI_2)
	{
		mt1 = translate(mat4x4(1.f), vec3(-CameraPosition.x, -CameraPosition.y, -CameraPosition.z));
		mtr = rotate(mat4x4(1.f), ROTATION_CONST, w);
		mt2 = translate(mat4x4(1.f), vec3(CameraPosition.x, CameraPosition.y, CameraPosition.z));

		mt = mt2 * mtr * mt1;

		LookAt_vector = mt * LookAt_vector;

		upDownAngle += ROTATION_CONST;
	}
}

void TurnDown()
{
	mat4x4 mt, mt1, mt2, mtr;
	vec3 f = LookAt_vector - CameraPosition;
	vec3 w = cross(f, LookUp_vector);

	w = normalize(w);

	if (upDownAngle - ROTATION_CONST > (float)-M_PI_2)
	{
		mt1 = translate(mat4x4(1.f), vec3(-CameraPosition.x, -CameraPosition.y, -CameraPosition.z));
		mtr = rotate(mat4x4(1.f), -ROTATION_CONST, w);
		mt2 = translate(mat4x4(1.f), vec3(CameraPosition.x, CameraPosition.y, CameraPosition.z));

		mt = mt2 * mtr * mt1;

		LookAt_vector = mt * LookAt_vector;
		// LookUp_vector = mt * LookUp_vector;

		upDownAngle -= ROTATION_CONST;
	}
}

void SpeedUp()
{
	if (currentSpeed < 5)
		++currentSpeed;
}

void SpeedDown()
{
	if (currentSpeed > 0)
		--currentSpeed;
}

void initGL(void)
{
	glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
	glShadeModel(GL_FLAT);
	glEnable(GL_DEPTH_TEST);
}

void mousePress(int button, int state, int x, int y)
{
	switch (button)
	{
	case GLUT_LEFT_BUTTON:
		if (state == GLUT_DOWN)
		{
			//FUNKCIJA
		}
		break;
	case GLUT_RIGHT_BUTTON:
		if (state == GLUT_DOWN)
		{
			//FUNKCIJA
		}
		break;
	default:
		break;
	}
}

void keyPress(unsigned char key, int x, int y)
{


	switch (key)
	{
	case 27: //ESC key
		exit(0);
		break;
		case 'a':
		//FUNCTION
		MoveLeft();
		break;
	case 'd':
		//FUNCTION
		MoveRight();
		break;
	case 'w':
		SpeedUp();
		break;
	case 's':
		SpeedDown();
		break;
	
	case 'u':
		SpeedUp();
		break;
	case 'j':

		SpeedDown();
		break;
	case 52:

		TurnLeft();
		break;
	case 54:

		TurnRight();
		break;
	case 50:
		TurnDown();
		break;
	case 56:
		TurnUp();
		break;
	}

}

/*--------------------------------------------------*/

int main(int argc, char** argv)
{
	glutInit(&argc, argv);

	glutInitDisplayMode(GLUT_DOUBLE | GLUT_DEPTH | GLUT_STENCIL);
	glutInitWindowSize(height * ratio, height);
	glutInitWindowPosition(150, 50);
	glutCreateWindow(title);
	createCoordinates();

	glutDisplayFunc(display);
	glutTimerFunc(100, timer, 0);
	glutReshapeFunc(reshape);

	glutMouseFunc(mousePress);
	glutKeyboardFunc(keyPress);

	initGL();
	glutMainLoop();

	return 0;
}

